#pragma once

#include <mail/libblackbox2/include/yandex/blackbox/accessors.h>
#include <mail/akita/service/include/blackbox/blackbox.h>
#include <functional>
#include <algorithm>

namespace akita::blackbox {

template < typename In, typename Out >
Address parseAddresses( In emails, Out internal, Out validated ) {
    Address defaultAddress;

    for (const auto& item: emails) {
        if ( item.native() ) {
            *internal++ = item.address();
        } else if( item.validated() ) {
            *validated++ = item.address();
        }

        if( item.isDefault() ) {
            defaultAddress = item.address();
        }
    }

    return defaultAddress;
}

template < typename In, typename Out >
Address parseAliases( In aliases, Out internal ) {
    Address defaultAddress;
    for(auto&& item: aliases) {
        const auto& aliasType = item.type();
        if (bb::AliasList::Item::Mailish != aliasType && bb::AliasList::Item::SSO != aliasType) {
            *internal++ = item.alias();
            defaultAddress = item.alias();
        }
    }
    return defaultAddress;
}

}
