#pragma once

#include <mail/akita/service/include/blackbox/internal/blackbox_transport_impl.h>
#include <mail/akita/service/include/blackbox/blackbox.h>


namespace akita::blackbox {

class BlackBoxImpl: public akita::BlackBox {
public:
    BlackBoxImpl(http_getter::ClientPtr client, const http_getter::Endpoint& endpoint, Logger logger,
                 const AllowedOAuthScopes& scopes)
        : transport_(std::move(client), endpoint, std::move(logger))
        , allowedOAuthScopes(scopes)
    { }

    void checkSessionSSLAsync(SessionRequestSSL request, OnCheck h) const override;

    void checkOAuthAsync(OAuthRequest request, OnCheck h) const override;

    bool isAllowedOAuthScope(const std::string& scope) const override {
        return allowedOAuthScopes.find(scope) != allowedOAuthScopes.end();
    }

private:
    BlackBoxTransportHTTPImpl transport_;
    AllowedOAuthScopes allowedOAuthScopes;
};

}
