#pragma once

#include <mail/akita/service/include/account/featured_account.h>
#include <mail/akita/service/include/blackbox/libblackbox2.h>
#include <mail/akita/service/include/blackbox/blackbox.h>
#include <mail/akita/service/include/blackbox/internal/dbfield_names.h>


namespace akita::blackbox {

class BlackBoxQuery {
    static bb::Options getAccountRequestOptions(const CommonCheckRequest& request, bool cookies) {
        bb::Attributes attrs;
        attrs << Attributes::haveOrganizationNameAttr() << Attributes::securityLevelAttr()
              << Attributes::havePasswordAttr() << Attributes::haveYaplusAttr()
              << Attributes::genderAttr() << Attributes::subscriptionMailStatusAttr();
        for (const auto& attr: request.attributesToCheck) {
            attrs << attr;
        }

        bb::OptAliases aliases;
        aliases << std::to_string(bb::AliasList::Item::PDD)
                << std::to_string(bb::AliasList::Item::Mailish)
                << std::to_string(bb::AliasList::Item::SSO);

        bb::DBFields dbFields;
        dbFields << DBFieldsNames::mailServiceUserId() << DBFieldsNames::mailLogin()
                 << DBFieldsNames::mailDataBase() << DBFieldsNames::firstName()
                 << DBFieldsNames::lastName() << DBFieldsNames::registrationDate()
                 << DBFieldsNames::timeZone() << DBFieldsNames::country() << DBFieldsNames::birthdayDate()
                 << DBFieldsNames::mailLoginRule() << DBFieldsNames::userLanguage();
        for (const auto& sid: request.sidsToCheck) {
            dbFields << DBFieldsNames::serviceUserId(sid);
        }

        bb::Options options;
        if (cookies) {
            options << bb::optMultisession;
        }
        options << bb::optRegname << bb::optAuthId << bb::optGetUserTicket
                << (request.deferredEmailListRequest ? bb::optGetYandexEmails : bb::optGetAllEmails)
                << attrs << aliases << dbFields;

        return options;
    }

public:

    static LoginReqData create(const SessionRequestSSL& request) {
        HttpArguments query;
        query.add("method", "sessionid");
        query.add("host", request.authHost);
        query.add("userip", request.common.realIp);
        query.add("user_port", request.common.realPort);
        query.add("get_login_id", "yes");
        const bb::Options options = getAccountRequestOptions(request.common, true);
        for (const bb::Option& o: options.list()) {
            query.add(o.key(), o.val());
        }

        HttpArguments body;
        body.add("sessionid", request.sessionID);
        body.add("sessguard", request.sessGuard);

        return LoginReqData {
            .query=query, .body=body.format()
        };
    }

    static LoginReqData create(const OAuthRequest& request) {
        HttpArguments query;
        query.add("method", "oauth");
        query.add("userip", request.common.realIp);
        query.add("user_port", request.common.realPort);
        query.add("get_login_id", "yes");
        const bb::Options options = getAccountRequestOptions(request.common, false);
        for (const bb::Option& o: options.list()) {
            query.add(o.key(), o.val());
        }

        HttpArguments body;
        body.add("oauth_token", request.token);

        return LoginReqData {
            .query=query, .body=body.format()
        };
    }
};

}
