#pragma once

#include <mail/akita/service/include/logger.h>
#include <mail/akita/service/include/blackbox/blackbox.h>
#include <mail/akita/service/include/blackbox/libblackbox2.h>
#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <mail/akita/service/include/config.h>
#include <mail/akita/service/include/errors.h>


namespace akita::blackbox {

using namespace http_getter::detail::operators;

struct BlackBoxTransportHTTPImpl {
    http_getter::ClientPtr client;
    Logger logger;
    const http_getter::Endpoint& endpoint;

    using OnData = std::function<void(mail_errors::error_code, std::string)>;

    BlackBoxTransportHTTPImpl(http_getter::ClientPtr c,
                              const http_getter::Endpoint& e,
                              Logger l)
        : client(std::move(c))
        , logger(std::move(l))
        , endpoint(e)
    { }

    void asyncQuery(LoginReqData data, OnData h) const {
        auto builder = client->toPOST(endpoint)
            .body(std::move(data.body))
            .getArgs("args"_arg=std::move(data.query))
        ;

        const auto answered = std::make_shared<bool>(false);
        client
            ->req(builder)
            ->call("blackbox", [h, answered, log=this->logger] (yhttp::response resp) {
                const unsigned s = resp.status / 100;
                if (s == 2) {
                    std::istringstream body(resp.body);
                    boost::property_tree::ptree data;
                    boost::property_tree::read_xml(body, data);
                    const std::string exception = data.get("doc.exception", "");

                    if (exception == "UNKNOWN" || exception == "DB_FETCHFAILED" || exception == "DB_EXCEPTION") {
                        std::ostringstream s;
                        s << "reason=[" << exception << ": " << data.get("doc.error", "") << "]";
                        LOGDOG_(log, notice, log::message=s.str());
                        return http_getter::Result::retry;
                    } else {
                        h(mail_errors::error_code(), resp.body);
                        *answered = true;
                        return http_getter::Result::success;
                    }
                } else if (s == 5) {
                    return http_getter::Result::retry;
                } else {
                    return http_getter::Result::fail;
                }
            }, [h, answered] (mail_errors::error_code) {
                if (!*answered) {
                    h(mail_errors::error_code(server::TransportError::timeout), "");
                }
            });
    }
};

}
