#pragma once

#include <string>

namespace akita::blackbox {

struct DBFieldsNames {
    static std::string mailServiceId() { return "2"; }
    static std::string mailServiceUserId() { return "subscription.suid.2"; }
    static std::string mailLogin() { return "subscription.login.2"; }
    static std::string mailDataBase() { return "hosts.db_id.2"; }
    static std::string firstName() { return "userinfo.firstname.uid"; }
    static std::string lastName() { return "userinfo.lastname.uid"; }
    static std::string registrationDate() { return "userinfo.reg_date.uid"; }
    static std::string timeZone() { return "account_info.tz.uid"; }
    static std::string country() { return "account_info.country.uid"; }
    static std::string birthdayDate() { return "account_info.birth_date.uid"; }
    static std::string mailLoginRule() { return "subscription.login_rule.2"; }
    static std::string userLanguage() { return "userinfo.lang.uid"; }
    static std::string mailServiceName() { return "pop"; }
    static std::string smtpServiceName() { return "smtp"; }

    static std::string serviceUserId(const std::string& serviceId) {
        return std::string("subscription.suid.") + serviceId;
    }
};

}
