#pragma once

#include <mail/akita/service/include/blackbox/blackbox.h>
#include <mail/akita/service/include/blackbox/libblackbox2.h>

namespace akita::blackbox {

class SessionResponseFactory {

    typedef BlackBox::SessionResponse SessionResponse;
    typedef BlackBox::OAuthInfo OAuthInfo;

    static bool hasPassword(const bb::SessionResp& response);
    static std::time_t age(const bb::SessionResp& response);
    static std::string getUid(const bb::SessionResp& response);
    static bool mailLoginAllowed(const std::string& mailLoginRule);
    static OAuthInfo getOAuthInfo(const bb::SessionResp& response);
    static bool checkAlias(const bb::SessionResp& response, bb::AliasList::Item::Type alias);
    static bool isMailish(const bb::SessionResp& response);
    static bool isSSO(const bb::SessionResp& response);
    static SubscriptionMailStatus getSubscriptionMailStatus(const bb::SessionResp& response);

    template <class SessionRespT>
    static SessionResponse::Status getStatus( const SessionRespT & response ) {
        // Oh dear great Almighty Lord of The Every things in existence (and slightly more than),
        // with all my pure humility and resignation I'm asking You about
        // absolution. Please forgive me the modest one (of the many programmers)
        // who made this little macros to reduce dumb and boring work for
        // this macros creation. I know, I've sin. But this is the least
        // evil of many ones. Amen.
        // PS: ...and thanks for the fish.
#define STATUS_TABLE_ENTRY( bbStatus, wmiStatus ) \
    case bb::SessionResp::bbStatus : return SessionResponse::Status_##wmiStatus

        switch ( response.status() )
        {
        STATUS_TABLE_ENTRY( Valid, valid );
        STATUS_TABLE_ENTRY( NeedReset, needReset );
        STATUS_TABLE_ENTRY( Expired, expired );
        STATUS_TABLE_ENTRY( NoAuth, noAuth );
        STATUS_TABLE_ENTRY( Disabled, disabled );
        STATUS_TABLE_ENTRY( Invalid, invalid );
        STATUS_TABLE_ENTRY( WrongGuard, wrongGuard );
        default:
            throw std::logic_error("Bad bb::SessionResp::status() return value!");
        };

#undef STATUS_TABLE_ENTRY
        // This string is to eliminate warning about no return value... in IDE!!! :(
        return SessionResponse::Status_invalid;
    }

    SessionResponseFactory& fromValidCookieResp(const bb::MultiSessionResp& sessionInfo,
                                               const bb::SessionResp& accInfo);
    SessionResponseFactory& fromInvalidCookieResp(const bb::MultiSessionResp& sInfo);

    SessionResponse _result;
    std::string _defaultPassId;
    std::string _userTicket;

public:
    SessionResponseFactory();

    SessionResponseFactory& fromCookie(bb::MultiSessionResp& resp, const std::string& currentUid);
    SessionResponseFactory& fromOAuth(bb::SessionResp& resp);

    bool succeeded() const {
        return SessionResponse::succeeded(_result.status);
    }

    std::string userTicket() const {
        return _userTicket;
    }

    static bool succeeded(const bb::SessionResp& resp) {
        return SessionResponse::succeeded(getStatus(resp));
    }

    SessionResponse sessionResponse() const {
        return _result;
    }

    bool isDefaultUser(const std::string& id) const {
        return id == _defaultPassId;
    }
};

}
