#pragma once

#include <string>
#include <mail/akita/service/include/logger.h>

class TzInfo {
    public:
        TzInfo(const std::string& timezone);

        const std::string& timezone() const {
            return _timezone;
        }

        const std::string& abbr() const {
            return _abbr;
        }

        int offset() const {
            return _offset;
        }

        static const std::string DEFAULT_TIMEZONE;
        static const unsigned int DEFAULT_TIMEZONE_OFFSET=14400;
    private:
        std::string _timezone;
        std::string _abbr;
        int _offset;
};
