#pragma once

#include <yplatform/ptree.h>
#include <ymod_tvm/module.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/akita/service/include/logger.h>


namespace akita {

using AllowedOAuthScopes = std::set<std::string>;

struct Config {
    std::shared_ptr<ymod_tvm::tvm2_module> tvm;
    http_getter::ModulePtr httpGetter;
    http_getter::Endpoint endpoint;
    AllowedOAuthScopes scopes;
    bool provideSessGuard = false;

    Config(const yplatform::ptree& cfg, std::shared_ptr<ymod_tvm::tvm2_module> tvm,
           http_getter::ModulePtr getter);
};

using ConfigPtr = std::shared_ptr<Config>;


}
