#pragma once

#include <mail_errors/error_code.h>
#include <string>


namespace akita::server {

enum class TransportError {
    timeout = 1,
    unknown,
};

struct TransportCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "transport";
    }

    std::string message(int v) const override;
};
const TransportCategory& getTransportCategory();
mail_errors::error_code::base_type make_error_code(TransportError e);
mail_errors::error_code make_error(TransportError e, std::string what="");


enum class Reason {
    ok = 0,
    unknown = 1,
    authNoAuth = 2001,
    authNoMailbox = 2003,
    authInternalProblem = 2005,
    authNoPassword = 2008,
    authUserBlocked = 2012,
    authUnallowedScope = 2013,
    authFrozen = 2020,
    authBadSessGuard = 2021,
};

std::string toString(Reason v);

}

namespace boost::system {
    template <>
    struct is_error_code_enum<akita::server::TransportError> : std::true_type {};
}