#pragma once

#include <memory>
#include <yplatform/log.h>
#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>


namespace akita {

namespace log {

LOGDOG_DEFINE_ATTRIBUTE(int, code)
LOGDOG_DEFINE_ATTRIBUTE(std::string, bb_response)
LOGDOG_DEFINE_ATTRIBUTE(std::string, reason)
LOGDOG_DEFINE_ATTRIBUTE(std::string, yandexuid)
LOGDOG_DEFINE_ATTRIBUTE(boost::optional<u_int32_t>, source)

using namespace ::logdog::attr;

constexpr static auto akita_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-akita-tskv-log"));

} // namespace log

inline auto getModuleLogger() {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, "akita");
    return ::logdog::make_log(log::akita_formatter, logger);
}

using ModuleLogger = decltype(getModuleLogger());

inline auto getLogger(const std::string& requestId) {
    return ::logdog::bind(getModuleLogger(), log::request_id=requestId);
}

using Logger = decltype(getLogger(""));

} // namespace akita
