from cpython cimport *
from libcpp.vector cimport vector
from libcpp.memory cimport shared_ptr

from mail.unistat.cpp.cython.logs cimport *
from mail.unistat.cpp.cython.meters cimport *
cimport mail.unistat.cpp.cython.run_cpp


cdef extern from "mail/akita/unistat/cpp/metrics.h" namespace "unistat":
    cdef cppclass Metric:
        Metric()

    cdef cppclass Logs:
        Logs(...)

    cdef cppclass LogMeters:
        LogMeters(...)

    cdef cppclass AkitaLog:
        AkitaLog(vector[PyObject *] pyMeters, vector[LogMeters] cppMeters, bool fastForward, const char* path)


cdef class AkitaMetric:
    cdef shared_ptr[Metric] __impl
    def __cinit__(self):
        self.__impl.reset(new Metric())


cdef class AkitaMetricsLog:
    cdef shared_ptr[AkitaLog] __impl

    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[LogMeters] cm
        for m in cppMeters:
            if isinstance(m, AkitaMetric):
                cm.push_back(LogMeters((<AkitaMetric>m).__impl))
            else:
                raise AttributeError("Unknown meter type for Akita")
        self.__impl.reset(new AkitaLog(pm, cm, fastForward, <const char*>path))


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[Logs] cppLogs
    for l in pyLogs:
        if isinstance(l, AkitaMetricsLog):
            cppLogs.push_back(
                Logs((<AkitaMetricsLog>l).__impl)
            )
        elif isinstance(l, HttpClientLog):
            cppLogs.push_back(
                Logs((<HttpClientLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")
    mail.unistat.cpp.cython.run_cpp.run(host, port, cppLogs, yplatformLogPath, logLevel)
