#include <mail/alabay/ymod_logbroker/include/consumer/event_buffer.h>
#include <mail/alabay/service/include/log.h>
#include <mail/alabay/service/include/repository.h>
#include <mail/webmail/http_api_helpers/include/find_dependency.h>
#include <yamail/data/serialization/yajl.h>
#include <yplatform/module_registration.h>
#include <yplatform/ptree.h>

namespace alabay {

struct DiskEventBuffer: public ymod_logbroker::EventBuffer, public yplatform::module {
    DiskEventBuffer(RepositoryPtr repository, OrgRepositoryPtr orgRepository)
        : EventBuffer()
        , repository(std::move(repository))
        , orgRepo(std::move(orgRepository))
    { }

    virtual ~DiskEventBuffer() = default;

    void asyncAddEvents(std::string_view, std::map<std::string_view, std::string_view> parsedLogLine, yplatform::task_context_ptr, ymod_logbroker::OnProbablyFlush hook) override {
        yamail::expected<DiskEvent> event = DiskEventBuilder::build(parsedLogLine);

        if (event) {
            eventsBuffer.emplace_back(std::move(*event));
        }

        hook(mail_errors::error_code(), false);
    }

    std::size_t size() const override {
        return eventsBuffer.size();
    }

    void asyncFlush(yplatform::task_context_ptr, ymod_logbroker::OnFlush hook) override {
        DiskEvents events;
        eventsBuffer.swap(events);
        repository->addDiskEvents(CommonParams(), std::move(events), hook);
    }

    DiskEvents eventsBuffer;
    RepositoryPtr repository;
    OrgRepositoryPtr orgRepo;
};

struct DiskEventBufferFactory: public ymod_logbroker::EventBufferFactory, public yplatform::module {
    virtual ~DiskEventBufferFactory() = default;

    void init(const yplatform::ptree& cfg) {
        repository_ = http_api::findDependency<Repository>(cfg, "dependencies.repository");
        orgRepo_ = http_api::findDependency<OrgRepository>(cfg, "dependencies.org_repository");

        consumerName_ = cfg.get<TString>("logbroker.consumer_name");
        yplatform::read_ptree(topics_, cfg.get_child("logbroker"), "topics");

        LOGDOG_(getModuleLogger(), notice, log::message="alabay::DiskEventBufferFactory loaded");
    }

    ymod_logbroker::EventBufferPtr create() const override {
        return std::make_shared<DiskEventBuffer>(repository_, orgRepo_);
    }

    const std::vector<TString>& topics() const override {
        return topics_;
    }

    const TString& consumerName() const override {
        return consumerName_;
    }

    std::vector<TString> topics_;
    TString consumerName_;
    RepositoryPtr repository_;
    OrgRepositoryPtr orgRepo_;
};

}

DEFINE_SERVICE_OBJECT(alabay::DiskEventBufferFactory)
