#include <mail/alabay/service/include/error.h>

namespace alabay {

std::string ConsumerCategory::message(int v) const {
    switch(ConsumerError(v)) {
        case ConsumerError::internalError:
            return "internal error";
        case ConsumerError::malformedEvent:
            return "malformed event";
        case ConsumerError::unsupportedEventType:
            return "unsupported event type";
    }
    return "unknown enum code";
}

const ConsumerCategory& getConsumerCategory() {
    static ConsumerCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(ConsumerError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getConsumerCategory());
}

mail_errors::error_code make_error(ConsumerError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

}

