#include <mail/alabay/service/include/handlers/event.h>
#include <mail/webmail/corgi/include/resolve/blackbox.h>


namespace alabay {

yamail::expected<EventListResult> eventList(CommonParams common, EventListParams params,
                                            HttpApiConfigPtr cfg, boost::asio::yield_context yield) {

    const auto range = cfg->repo->eventList(common, params, io_result::make_yield_context(yield));

    EventListResult res;
    std::copy(std::make_move_iterator(range.begin()), std::make_move_iterator(range.end()), std::back_inserter(res.data));

    if (params.page.count() == res.data.size()) {
        std::size_t first = 0;
        if (params.page.first()) {
            first = std::stoll(*params.page.first());
        }

        res.next = std::to_string(first + params.page.count());
    }

    return res;
}

yamail::expected<EmptyResult> eventAdd(CommonParams common, Events events, HttpApiConfigPtr cfg, boost::asio::yield_context yield) {
    cfg->repo->addEvents(common, events, io_result::make_yield_context(yield));

    return {};
}

}
