#include <mail/alabay/service/include/handlers/organization.h>
#include <mail/webmail/corgi/include/resolve/blackbox.h>


namespace alabay {

yamail::expected<OrganizationEnableResult> organizationInit(OrganizationParams common, HttpApiConfigPtr cfg,
                                                            boost::asio::yield_context yield) {

    cfg->orgRepo->enableOrganization(common, io_result::make_yield_context(yield));

    return OrganizationEnableResult();
}

yamail::expected<OrganizationShowResult> organizationShow(OrganizationParams common, HttpApiConfigPtr cfg,
                                                          boost::asio::yield_context yield) {

    OrganizationShowResult ret;
    const auto org = cfg->orgRepo->getOrganization(common, io_result::make_yield_context(yield));
    if (org) {
        ret.state = org->state;
    }

    return ret;
}

yamail::expected<OrganizationDisableResult> organizationDisable(OrganizationParams common, HttpApiConfigPtr cfg, boost::asio::yield_context yield) {
    cfg->orgRepo->disableOrganization(common, cfg->intervalBeforeRemovingOrganization + std::time(nullptr), io_result::make_yield_context(yield));

    return OrganizationDisableResult();
}

yamail::expected<UserSettingResult> userEnable(SettingParams params, OrgId orgId, http_getter::TypedClientPtr client,
                                               HttpApiConfigPtr cfg, boost::asio::yield_context yield) {

    UidsSet pdd = corgi::pddUids({params.uid}, *client, cfg->resolverConfig, yield).value_or_throw();
    if (pdd.empty()) {
        return UserSettingResult();
    }

    cfg->orgRepo->enableUser(params, orgId, "any login", io_result::make_yield_context(yield));

    return {};
}

yamail::expected<UserSettingResult> userDisable(SettingParams params, http_getter::TypedClientPtr client,
                                                HttpApiConfigPtr cfg, boost::asio::yield_context yield) {

    UidsSet pdd = corgi::pddUids({params.uid}, *client, cfg->resolverConfig, yield).value_or_throw();
    if (pdd.empty()) {
        return UserSettingResult();
    }

    cfg->orgRepo->disableUser(params, io_result::make_yield_context(yield));

    return {};
}

}
