#pragma once

#include <mail_errors/error_code.h>
#include <yamail/expected.h>


namespace alabay {

constexpr int ENUM_ERROR_STARTING_VALUE = 1;

enum class ConsumerError {
    internalError = ENUM_ERROR_STARTING_VALUE,
    malformedEvent,
    unsupportedEventType,
};

struct ConsumerCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "consumer error";
    }

    std::string message(int v) const override;
};
const ConsumerCategory& getConsumerCategory();
mail_errors::error_code::base_type make_error_code(ConsumerError e);
mail_errors::error_code make_error(ConsumerError e, std::string what="");
inline auto make_unexpected(ConsumerError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}

}

namespace boost::system {
template <>
struct is_error_code_enum<alabay::ConsumerError> : std::true_type { };
}
