#pragma once

#include <mail/alabay/service/include/types.h>
#include <mail/alabay/service/include/result.h>
#include <mail/alabay/service/include/config.h>


namespace alabay {

yamail::expected<OrganizationEnableResult> organizationInit(OrganizationParams common, HttpApiConfigPtr cfg, boost::asio::yield_context yield);
yamail::expected<OrganizationShowResult> organizationShow(OrganizationParams common, HttpApiConfigPtr cfg, boost::asio::yield_context yield);
yamail::expected<OrganizationDisableResult> organizationDisable(OrganizationParams common, HttpApiConfigPtr cfg, boost::asio::yield_context yield);

yamail::expected<UserSettingResult> userEnable(SettingParams params, OrgId orgId, http_getter::TypedClientPtr client,
                                               HttpApiConfigPtr cfg, boost::asio::yield_context yield);

yamail::expected<UserSettingResult> userDisable(SettingParams params, http_getter::TypedClientPtr client,
                                                HttpApiConfigPtr cfg, boost::asio::yield_context yield);

}
