from argparse import ArgumentParser
from collections import namedtuple
import os
import yaml
import json
import logging
import mail.unistat.cpp.cython.logs as logs
import mail.alabay.unistat.cpp.run as unistat


logging.basicConfig(level=logging.WARNING, format='[%(asctime)s] [%(levelname)s]: %(message)s')
log = logging.getLogger(__name__)


def parse_args():
    parser = ArgumentParser()
    parser.add_argument('-H', '--host', default='::')
    parser.add_argument('-p', '--port', default=8082, type=int)
    parser.add_argument('-d', '--dir', default='.')
    parser.add_argument('-s', action='store_true', help='read file logs from start')
    parser.add_argument('-l', '--log', help='path for yplatform.log')
    parser.add_argument('config')
    return parser.parse_args()


def make_config(data):
    return Config(
        application_log=os.path.join(os.curdir, data['config']['log']['alabay']['sinks'][0]['path']),
    )


class ConsumerMetric:
    def __init__(self):
        self._count = 0

    def update(self, data):
        if 'is_metric' in data and 'message' in data:
            if 'pushed to database' == data['message']:
                self._count += int(data['count'])

    def get(self):
        return json.dumps(['pushed_summ', self._count])


def make_consumer_meters():
    return [
        ConsumerMetric()
    ]


Config = namedtuple('Config', (
    'application_log',
))


def main():
    args = parse_args()
    log.info('chdir %s' % os.path.abspath(args.dir))
    os.chdir(args.dir)

    with open(args.config) as f:
        config = make_config(yaml.load(f, Loader=yaml.FullLoader))

    fast_forward = args.s

    metrics = make_consumer_meters()

    metrics_log = logs.TskvLog(
        metrics,
        [],
        fast_forward,
        config.application_log
    )

    logs_list = [metrics_log]

    unistat.run(args.host, args.port, logs_list, args.log, logLevel='info')


if __name__ == '__main__':
    main()
