#include <mail/alabay/service/include/repository.h>
#include <mail/alabay/service/include/log.h>
#include <mail/alabay/service/include/types_reflection.h>
#include <mail/webmail/clickhouse/include/executer.h>
#include <mail/http_getter/client/include/endpoint_reflection.h>
#include <mail/webmail/corgi/include/types_error.h>
#include <yplatform/module_registration.h>


namespace alabay {

const auto AddEvents = BOOST_HANA_STRING("AddEvents");
const auto AddDiskEvents = BOOST_HANA_STRING("AddDiskEvents");
const auto ListEvents = BOOST_HANA_STRING("ListEvents");

struct ClickHouseHttp: public Repository, public yplatform::module {

    virtual ~ClickHouseHttp() = default;

    void init(const yplatform::ptree& cfg) {
        executer.initConfig(cfg, ListEvents, AddEvents, AddDiskEvents);

        LOGDOG_(getModuleLogger(executer.loggerName), notice,
            log::message="alabay::ClickHouseHttp module initialized"
        );
    }

    void asyncAddEvents(const CommonParams& c, Events events, OnExecute cb) const override {
        executer.insert(c.requestId, AddEvents).perform(std::move(events), cb);
    }

    void asyncAddDiskEvents(const CommonParams& c, DiskEvents events, OnExecute cb) const override {
        executer.insert(c.requestId, AddDiskEvents).perform(std::move(events), cb);
    }

    void asyncEventList(const CommonParams& c, const EventListParams& params, OnEvents cb) const override {
        executer.select(c.requestId, ListEvents,
                        fmt::arg("org_id", c.orgId),
                        fmt::arg("date_from", params.dateFrom),
                        fmt::arg("first", params.page.first().value_or("0")),
                        fmt::arg("count", params.page.count()))
                .perform([] (Event ev) { return ev; }, cb);
    }

    clickhouse::Executer<> executer;
};

}

DEFINE_SERVICE_OBJECT(alabay::ClickHouseHttp)
