#pragma once

#include <pgg/query/ids.h>
#include <pgg/query/boundaries.h>
#include <pgg/query/query_register.h>
#include <mail/alabay/service/include/types.h>


namespace alabay::reflection {
using UidVec = std::vector<std::int64_t>;
struct RequestInfo {
    std::int64_t orgId;
    std::int64_t uid;
    std::string requestId;

    RequestInfo() = default;
    RequestInfo(const CommonParams& c)
        : orgId(c.orgId)
        , uid(c.adminUid)
        , requestId(c.requestId)
    { }
};
}

BOOST_FUSION_ADAPT_STRUCT(alabay::reflection::RequestInfo,
    orgId,
    uid,
    requestId,
)


BOOST_FUSION_DEFINE_STRUCT((alabay)(reflection), Organization,
    (std::string, state)
    (std::time_t, doom_date)
    (std::time_t, created)
)

BOOST_FUSION_DEFINE_STRUCT((alabay)(reflection), OptionalOrganization,
   (boost::optional<alabay::reflection::Organization>, organization)
)

BOOST_FUSION_DEFINE_STRUCT((alabay)(reflection), WithResult,
    (boost::optional<std::string>, result)
)


PGG_QUERY_ID((alabay)(query), Uid, std::int64_t)
PGG_QUERY_ID((alabay)(query), OrgId, std::int64_t)
PGG_QUERY_ID((alabay)(query), RequestInfo, alabay::reflection::RequestInfo)
PGG_QUERY_ID((alabay)(query), DoomDate, std::time_t)
PGG_QUERY_ID((alabay)(query), Login, std::string)

namespace alabay::query {

struct EnableOrganization: pgg::query::QueryImpl<EnableOrganization, OrgId> {
    using Inherited::Inherited;
};

struct DisableOrganization: pgg::query::QueryImpl<DisableOrganization, OrgId, DoomDate> {
    using Inherited::Inherited;
};

struct GetOrganization: pgg::query::QueryImpl<GetOrganization, OrgId> {
    using Inherited::Inherited;
};

struct EnableUser: pgg::query::QueryImpl<EnableUser, Uid, OrgId, Login> {
    using Inherited::Inherited;
};

struct DisableUser: pgg::query::QueryImpl<DisableUser, Uid> {
    using Inherited::Inherited;
};

using QueriesRegister = pgg::query::RegisterQueries<
      EnableOrganization
    , DisableOrganization
    , GetOrganization
    , EnableUser
    , DisableUser
>;

using ParametersRegister = pgg::query::RegisterParameters<>;

}
