#include <mail/alabay/ymod_logbroker/include/consumer/log.h>


namespace ymod_logbroker {

void consumerProcessed(const ConsumerLogger& log, 
                       yplatform::task_context_ptr ctx, 
                       const TVector<TDataReceivedEvent::TMessage>& msgs) {
    LOGDOG_(log, notice,
        log::request_id=ctx->request_id(),
        log::context_id=ctx->uniq_id(),
        log::status="success",
        log::duration=getCtxDurationMs(ctx),
        log::messages_count=msgs.size(),
        log::front_offset=msgs.front().GetOffset(),
        log::front_seqno=msgs.front().GetSeqNo(),
        log::back_offset=msgs.back().GetOffset(),
        log::back_seqno=msgs.back().GetSeqNo()
    );
}
void consumerFailed(const ConsumerLogger& log, 
                    yplatform::task_context_ptr ctx, 
                    const TVector<TDataReceivedEvent::TMessage>& msgs, 
                    const mail_errors::error_code& ec) {
    LOGDOG_(log, notice,
        log::request_id=ctx->request_id(),
        log::context_id=ctx->uniq_id(),
        log::status="failed",
        log::duration=getCtxDurationMs(ctx),
        log::messages_count=msgs.size(),
        log::front_offset=msgs.front().GetOffset(),
        log::front_seqno=msgs.front().GetSeqNo(),
        log::back_offset=msgs.back().GetOffset(),
        log::back_seqno=msgs.back().GetSeqNo(),
        log::error_code=ec
    );
}
void consumerFailed(const ConsumerLogger& log, 
                    yplatform::task_context_ptr ctx, 
                    const TVector<TDataReceivedEvent::TMessage>& msgs, 
                    const std::exception& e) {
    LOGDOG_(log, notice,
        log::request_id=ctx->request_id(),
        log::context_id=ctx->uniq_id(),
        log::status="failed",
        log::duration=getCtxDurationMs(ctx),
        log::messages_count=msgs.size(),
        log::front_offset=msgs.front().GetOffset(),
        log::front_seqno=msgs.front().GetSeqNo(),
        log::back_offset=msgs.back().GetOffset(),
        log::back_seqno=msgs.back().GetSeqNo(),
        log::exception=e
    );
}


}
