#include <mail/alabay/ymod_logbroker/include/consumer/metrics.h>


namespace ymod_logbroker {

ConsumerMetrics::ConsumerMetrics(ModuleLogger l)
    : logger(std::move(l))
{
    LOGDOG_(logger, notice, log::message="starting", log::is_metric=true);
}

ConsumerMetrics::~ConsumerMetrics() {
    LOGDOG_(logger, notice, log::message="finished", log::is_metric=true);
}

void ConsumerMetrics::dataReceived(const NYdb::NPersQueue::TReadSessionEvent::TDataReceivedEvent& event) const {
    LOGDOG_(logger, notice, log::message="data received", log::is_metric=true, log::count=event.GetMessages().size());
}

void ConsumerMetrics::pushedToDatabase(std::size_t count) const {
    LOGDOG_(logger, notice, log::message="pushed to database", log::is_metric=true, log::count=count);
}

void ConsumerMetrics::createPartitionStream() const {
    LOGDOG_(logger, notice, log::message="create partition", log::is_metric=true);
}

void ConsumerMetrics::destroyPartitionStream() const {
    LOGDOG_(logger, notice, log::message="destroy partition", log::is_metric=true);
}

void ConsumerMetrics::closeSession() const {
    LOGDOG_(logger, notice, log::message="close session", log::is_metric=true);
}

void ConsumerMetrics::cannotProcessMessage() const {
    LOGDOG_(logger, notice, log::message="Can't process message", log::is_metric=true);
}

}
