#pragma once

#include <mail/alabay/ymod_logbroker/include/consumer/event_buffer.h>
#include <mail/alabay/ymod_logbroker/include/consumer/log.h>
#include <mail/alabay/ymod_logbroker/include/log.h>
#include <mail/alabay/ymod_logbroker/include/producer/log.h>
#include <mail/webmail/ymod_switchbox/include/module.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <library/cpp/tvmauth/client/facade.h>

namespace ymod_logbroker {

struct ConsumerConfig {
    TString logbrokerEndpoint;
    TString logbrokerDatabase;
    TString driverLogPath;
    TString tvmService;
    NTvmAuth::NTvmApi::TClientSettings tvmClientSettings;
    TDuration waitDuration;
    bool commitAfterProcessing = false;
    bool useSecureConnection = false;
    bool disableClusterDiscovery = false;
    EventBufferFactoryPtr eventBufferFactory;
    ModuleLogger logger;
    ConsumerLogger consumerLog;
    ymod_switchbox::ModuleProviderPtr switchbox;
};
using ConsumerConfigPtr = std::shared_ptr<ConsumerConfig>;

struct CommonConfig {
    TString logbrokerEndpoint;
    TString logbrokerDatabase;
    TString driverLogPath;
    TString tvmService;
    NTvmAuth::NTvmApi::TClientSettings tvmClientSettings;
    bool useSecureConnection = false;
    bool disableClusterDiscovery = false;
    ModuleLogger logger;
};

struct ProducerConfig {
    CommonConfig common;
    ProducerLogger producerLogger;
    TString topicName;
};
using ProducerConfigPtr = std::shared_ptr<ProducerConfig>;

}
