#pragma once

#include <io_result/io_result.h>
#include <io_result/hooks.h>
#include <yplatform/task_context.h>
#include <util/generic/string.h>
#include <mail/alabay/ymod_logbroker/include/parse_helpers.h>


namespace ymod_logbroker {

using OnProbablyFlush = io_result::Hook<bool>;
using OnFlush = io_result::Hook<>;

struct EventBuffer {
    virtual ~EventBuffer() = default;
    template <typename Handler>
    auto addEvents(std::string_view rawLine, helpers::ParsedEvent parsedLogLine, yplatform::task_context_ptr ctx, Handler handler) {
        io_result::detail::init_async_result<Handler, OnProbablyFlush> init(handler);
        asyncAddEvents(rawLine, parsedLogLine, std::move(ctx), init.handler);
        return init.result.get();
    }
    template <typename Handler>
    auto probablyFlush(yplatform::task_context_ptr ctx, Handler handler) {
        io_result::detail::init_async_result<Handler, OnProbablyFlush> init(handler);
        asyncProbablyFlush(std::move(ctx), init.handler);
        return init.result.get();
    }
    template <typename Handler>
    auto flush(yplatform::task_context_ptr ctx, Handler handler) {
        io_result::detail::init_async_result<Handler, OnFlush> init(handler);
        asyncFlush(std::move(ctx), init.handler);
        return init.result.get();
    }
    virtual std::size_t size() const = 0;

protected:
    virtual void asyncAddEvents(std::string_view raw, helpers::ParsedEvent parsed, yplatform::task_context_ptr, OnProbablyFlush) = 0;
    virtual void asyncFlush(yplatform::task_context_ptr, OnFlush) = 0;
    virtual void asyncProbablyFlush(yplatform::task_context_ptr, OnProbablyFlush handler) {
        handler({}, false);
    }
};
using EventBufferPtr = std::shared_ptr<EventBuffer>;

struct EventBufferFactory {
    virtual ~EventBufferFactory() = default;

    virtual EventBufferPtr create() const = 0;

    virtual const std::vector<TString>& topics() const = 0;

    virtual const TString& consumerName() const = 0;
};
using EventBufferFactoryPtr = std::shared_ptr<EventBufferFactory>;

}
