#pragma once

#include <mail/alabay/ymod_logbroker/include/log.h>
#include <kikimr/public/sdk/cpp/client/ydb_persqueue/persqueue.h>


namespace ymod_logbroker {
namespace log {
LOGDOG_DEFINE_ATTRIBUTE(ui64, front_offset)
LOGDOG_DEFINE_ATTRIBUTE(ui64, front_seqno)
LOGDOG_DEFINE_ATTRIBUTE(ui64, back_offset)
LOGDOG_DEFINE_ATTRIBUTE(ui64, back_seqno)
}

inline auto getConsumerLogger(const std::string& name) {
    static constexpr auto consumerAccess = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-ymod-logbroker-consumer-tskv-log"));

    return ::logdog::make_log(
        consumerAccess,
        std::make_shared<yplatform::log::source>(yplatform::log::find(name, true))
    );
}

using ConsumerLogger = decltype(getConsumerLogger(""));

using TDataReceivedEvent = NYdb::NPersQueue::TReadSessionEvent::TDataReceivedEvent;

void consumerProcessed(const ConsumerLogger& log, 
                       yplatform::task_context_ptr ctx, 
                       const TVector<TDataReceivedEvent::TMessage>& msgs);
void consumerFailed(const ConsumerLogger& log, 
                    yplatform::task_context_ptr ctx, 
                    const TVector<TDataReceivedEvent::TMessage>& msgs, 
                    const mail_errors::error_code& ec);
void consumerFailed(const ConsumerLogger& log, 
                    yplatform::task_context_ptr ctx, 
                    const TVector<TDataReceivedEvent::TMessage>& msgs, 
                    const std::exception& e);

}
