#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#undef L_

namespace ymod_logbroker {
namespace log {
using namespace ::logdog::attr;

LOGDOG_DEFINE_ATTRIBUTE(std::size_t, count)
LOGDOG_DEFINE_ATTRIBUTE(bool, is_metric)
LOGDOG_DEFINE_ATTRIBUTE(std::string, status)
LOGDOG_DEFINE_ATTRIBUTE(double, duration)
LOGDOG_DEFINE_ATTRIBUTE(std::size_t, messages_count)

}

inline double getCtxDurationMs(yplatform::task_context_ptr ctx) {
    return (
        boost::posix_time::microsec_clock::local_time() - ctx->begin_time()
    ).total_milliseconds() / 1000.;
}

inline auto getModuleLogger(const std::string& name) {
    constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-ymod-logbroker-tskv-log"));

    return ::logdog::make_log(
        formatter,
        std::make_shared<yplatform::log::source>(yplatform::log::find(name, true))
    );
}
using ModuleLogger = decltype(getModuleLogger(""));

}
