#pragma once

#include <optional>
#include <charconv>
#include <string>
#include <map>


namespace ymod_logbroker::helpers {

using ParsedEvent = std::map<std::string_view, std::string_view>;
using ParsedUid = std::uint64_t;

template<class ... StringView>
bool isEventContainsValueFromRange(const ParsedEvent& event, std::string_view name, StringView... values) {
    const auto it = event.find(name);

    return it == event.end() ? false : (... || (it->second == values));
}

inline bool productionUser(ParsedUid uid) {
    return !(1120000000000000 <= uid && uid <= 1130000000000000);
}

inline std::string_view makeUid(std::string_view uid) {
    std::size_t index = uid.find_first_not_of('0');
    if (index == std::string::npos) {
        return std::string_view();
    }
    return uid.substr(index);
}

inline std::optional<std::string> getOpt(const ParsedEvent& event, std::string_view name) {
    const auto it = event.find(name);
    return it == event.end() ? std::optional<std::string>() : std::string(it->second);
}

inline std::string get(const ParsedEvent& event, std::string_view name, const std::string& def = "") {
    return getOpt(event, name).value_or(def);
}

template <typename Result>
bool parseNumber(std::string_view src, Result& result) {
    auto [ptr, ec] = std::from_chars(src.data(), src.data() + src.size(), result);
    if (ptr != src.data() + src.size() || ec != std::errc()) {
        return false;
    }
    return true;
}

}
