#pragma once

#include <io_result/io_result.h>
#include <yplatform/task_context.h>
#include <mail/alabay/ymod_logbroker/include/task_context_holder.h>


namespace ymod_logbroker {

struct Task {
    using Messages = std::list<std::string>;
    using MessagesPtr = std::shared_ptr<Messages>;

    yplatform::task_context_ptr ctx;
    MessagesPtr messages;
    io_result::Hook<> hook;

    Task(yplatform::task_context_ptr other, MessagesPtr msgs, io_result::Hook<>&& h)
        : ctx(boost::make_shared<TaskContext>(*other))
        , messages(std::move(msgs))
        , hook(std::move(h))
    {
        ctx->begin();
    }
};

struct OutputTaskBuffer {
    virtual ~OutputTaskBuffer() = default;

    virtual void pushBack(Task) = 0;
};
using OutputTaskBufferPtr = std::shared_ptr<OutputTaskBuffer>;

}
