#pragma once

#include <mail/alabay/ymod_logbroker/include/producer/buffer.h>
#include <queue>
#include <mutex>


namespace ymod_logbroker {

struct InputTaskBuffer {
    virtual ~InputTaskBuffer() = default;

    virtual Task popFront() = 0;
};

struct InputOutputBuffer: public OutputTaskBuffer, public InputTaskBuffer {
    std::mutex m;
    std::condition_variable cv;
    std::queue<Task> queue;

    virtual ~InputOutputBuffer() = default;

    Task popFront() override {
        std::unique_lock lock(m);
        cv.wait(lock, [this] () { return !queue.empty(); });

        Task ret = std::move(queue.front());
        queue.pop();
        lock.unlock();

        return ret;
    }

    void pushBack(Task task) override {
        {
            std::lock_guard lock(m);
            queue.emplace(std::move(task));
        }
        cv.notify_one();
    }
};

}
