#pragma once

#include <mail_errors/error_code.h>
#include <yamail/expected.h>


namespace ymod_logbroker {

constexpr int ENUM_ERROR_STARTING_VALUE = 1;

enum class ProduceError {
    cancelled = ENUM_ERROR_STARTING_VALUE,
    sessionClosed,
    internalError,
};

struct ProduceCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "produce error";
    }

    std::string message(int v) const override;
};
const ProduceCategory& getProduceCategory();
mail_errors::error_code::base_type make_error_code(ProduceError e);
mail_errors::error_code make_error(ProduceError e, std::string what="");
inline auto make_unexpected(ProduceError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}

}

namespace boost::system {
template <>
struct is_error_code_enum<ymod_logbroker::ProduceError> : std::true_type { };
}
