#pragma once

#include <mail/alabay/ymod_logbroker/include/log.h>
#include <mail/alabay/ymod_logbroker/include/producer/buffer.h>


namespace ymod_logbroker {

inline auto getProducerLogger(const std::string& name) {
    constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-ymod-logbroker-producer-tskv-log"));

    return ::logdog::make_log(
        formatter,
        std::make_shared<yplatform::log::source>(yplatform::log::find(name, true))
    );
}
using ProducerLogger = decltype(getProducerLogger(""));

void producerLogSuccess(const ProducerLogger& log, const Task& task);
void producerLogFailed (const ProducerLogger& log, const Task& task, const mail_errors::error_code& ec);

}
