#pragma once

#include <library/cpp/tvmauth/client/facade.h>
#include <kikimr/public/sdk/cpp/client/ydb_persqueue/persqueue.h>
#include <kikimr/public/sdk/cpp/client/tvm/tvm.h>
#include <mail/alabay/ymod_logbroker/include/config.h>
#include <mail/tvm_guard/tvm_api/log_tskv.h>
#include <butil/network/utils.h>


namespace ymod_logbroker {

std::shared_ptr<NTvmAuth::TTvmClient> makeTvmClient(const CommonConfig& config);
std::shared_ptr<NYdb::ICredentialsProviderFactory> makeTvmProvider(const ProducerConfig& config);

struct SessionProvider {
    SessionProvider(const CommonConfig& common, std::shared_ptr<NYdb::ICredentialsProviderFactory> tvmProvider)
        : driverConfig(createDriverConfig(common, tvmProvider))
        , driver(driverConfig)
        , persqueueClient(driver)
    { }

    std::shared_ptr<NYdb::NPersQueue::IWriteSession> createSession(const ProducerConfig& config) {
        return persqueueClient.CreateWriteSession(writeSessionSettings(config));
    }

    static NYdb::NPersQueue::TWriteSessionSettings writeSessionSettings(const ProducerConfig& config);
    static NYdb::TDriverConfig createDriverConfig(const CommonConfig& config, std::shared_ptr<NYdb::ICredentialsProviderFactory> tvmProvider);

    NYdb::TDriverConfig driverConfig;
    NYdb::TDriver driver;
    NYdb::NPersQueue::TPersQueueClient persqueueClient;
};

}
