#include <mail/alabay/ymod_logbroker/include/producer/error.h>

namespace ymod_logbroker {

std::string ProduceCategory::message(int v) const {
    switch(ProduceError(v)) {
        case ProduceError::sessionClosed:
            return "session closed";
        case ProduceError::internalError:
            return "internal error";
        case ProduceError::cancelled:
            return "cancelled";
    }
    return "unknown enum code";
}

const ProduceCategory& getProduceCategory() {
    static ProduceCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(ProduceError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getProduceCategory());
}

mail_errors::error_code make_error(ProduceError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

}
