#include <mail/alabay/ymod_logbroker/include/producer/log.h>


namespace ymod_logbroker {

void producerLogSuccess(const ProducerLogger& log, const Task& task) {
    LOGDOG_(log, notice,
        log::request_id=task.ctx->request_id(),
        log::context_id=task.ctx->uniq_id(),
        log::status="success",
        log::duration=getCtxDurationMs(task.ctx),
        log::messages_count=task.messages->size()
    );
}

void producerLogFailed(const ProducerLogger& log, const Task& task, const mail_errors::error_code& ec) {
    LOGDOG_(log, notice,
        log::request_id=task.ctx->request_id(),
        log::context_id=task.ctx->uniq_id(),
        log::status="failed",
        log::duration=getCtxDurationMs(task.ctx),
        log::messages_count=task.messages->size(),
        log::error_code=ec
    );
}

}
