#include <mail/alabay/ymod_logbroker/include/session_provider.h>

namespace ymod_logbroker {

std::shared_ptr<NTvmAuth::TTvmClient> makeTvmClient(const CommonConfig& config) {
    auto log = tvm_guard::makeLogger(config.logger);
    return std::make_shared<NTvmAuth::TTvmClient>(config.tvmClientSettings, std::move(log));
}

std::shared_ptr<NYdb::ICredentialsProviderFactory> makeTvmProvider(const ProducerConfig& config) {
    std::shared_ptr<NTvmAuth::TTvmClient> tvmClient = makeTvmClient(config.common);
    return NYdb::CreateTVMCredentialsProviderFactory(tvmClient, config.common.tvmService);
}

NYdb::NPersQueue::TWriteSessionSettings SessionProvider::writeSessionSettings(const ProducerConfig& config) {
    NYdb::NPersQueue::TWriteSessionSettings settings;

    settings.ClusterDiscoveryMode(
        config.common.disableClusterDiscovery ? NYdb::NPersQueue::EClusterDiscoveryMode::Off
                                              : NYdb::NPersQueue::EClusterDiscoveryMode::On
    );

    settings.Path(config.topicName);

    std::ostringstream out;
    out << getHostName() << "_" << std::this_thread::get_id();
    settings.MessageGroupId(out.str());

    return settings;
}

NYdb::TDriverConfig SessionProvider::createDriverConfig(const CommonConfig& config, std::shared_ptr<NYdb::ICredentialsProviderFactory> tvmProvider) {
    auto driverConfig = NYdb::TDriverConfig()
        .SetNetworkThreadsNum(2)
        .SetEndpoint(config.logbrokerEndpoint)
        .SetDatabase(config.logbrokerDatabase)
        .SetCredentialsProviderFactory(tvmProvider)
        .SetLog(CreateLogBackend(config.driverLogPath, ELogPriority::TLOG_NOTICE));

    if (config.useSecureConnection) {
        driverConfig.UseSecureConnection();
    }

    return driverConfig;
}

}
