#ifndef APQ_CONNECTION_HPP
#define APQ_CONNECTION_HPP

#include <apq/connection_service.hpp>

namespace apq {

class connection : public boost::asio::basic_io_object<connection_service>
{
public:
    explicit connection(boost::asio::io_service& ios)
        : boost::asio::basic_io_object<connection_service>(ios)
    {
    }

    template <typename Handler>
    void async_connect(const std::string& conninfo, Handler handler)
    {
        this->get_service().async_connect(this->get_implementation(), conninfo, handler);
    }

    template <typename Handler>
    void async_request(const std::string& query, Handler handler)
    {
        this->get_service().async_request(this->get_implementation(), query, handler);
    }

    template <typename Handler>
    void async_request(const query& q, Handler handler, result_format rf = result_format_text)
    {
        this->get_service().async_request(this->get_implementation(), q, handler, rf);
    }

    template <typename Handler>
    void async_request_single(
        const query& q,
        Handler handler,
        result_format rf = result_format_text)
    {
        this->get_service().async_request_single(this->get_implementation(), q, handler, rf);
    }

    template <typename Handler>
    void async_update(const std::string& query, Handler handler)
    {
        this->get_service().async_update(this->get_implementation(), query, handler);
    }

    template <typename Handler>
    void async_update(const query& q, Handler handler)
    {
        this->get_service().async_update(this->get_implementation(), q, handler);
    }

    template <typename Handler>
    void async_execute(const std::string& query, Handler handler)
    {
        this->get_service().async_execute(this->get_implementation(), query, handler);
    }

    void close()
    {
        this->get_service().close(this->get_implementation());
    }
};

} // namespace apq

#endif
