#ifndef APQ_CONNECTION_SERVICE_HPP
#define APQ_CONNECTION_SERVICE_HPP

#include <apq/detail/service_base.hpp>
#include <apq/detail/connection_service.hpp>

namespace apq {

class connection_service : public detail::service_base<connection_service>
{
public:
    typedef boost::shared_ptr<detail::connection_impl> implementation_type;

    explicit connection_service(boost::asio::io_service& ios)
        : detail::service_base<connection_service>(ios)
    {
    }

    void construct(implementation_type& impl)
    {
        impl = boost::make_shared<detail::connection_impl>(get_io_service());
    }

    void destroy(implementation_type& impl)
    {
        impl.reset();
    }

    void shutdown_service()
    {
    }

    template <typename Handler>
    void async_connect(implementation_type& impl, const std::string& conninfo, Handler&& handler)
    {
        detail::async_connect(impl, conninfo, std::forward<Handler>(handler));
    }

    template <typename Handler>
    void async_request(implementation_type& impl, const std::string& query, Handler&& handler)
    {
        detail::async_op<detail::request_cont>(impl, std::forward<Handler>(handler), query);
    }

    template <typename Handler>
    void async_request(
        implementation_type& impl,
        const query& q,
        Handler&& handler,
        result_format rf = result_format_text)
    {
        detail::async_op<detail::request_cont>(impl, std::forward<Handler>(handler), q, rf);
    }

    template <typename Handler>
    void async_request_single(
        implementation_type& impl,
        const query& q,
        Handler&& handler,
        result_format rf = result_format_text)
    {
        detail::async_op<detail::single_tuple_request_cont>(
            impl, std::forward<Handler>(handler), q, rf);
    }

    template <typename Handler>
    void async_update(implementation_type& impl, const std::string& query, Handler&& handler)
    {
        detail::async_op<detail::update_cont>(impl, std::forward<Handler>(handler), query);
    }

    template <typename Handler>
    void async_update(implementation_type& impl, const query& q, Handler&& handler)
    {
        detail::async_op<detail::update_cont>(impl, std::forward<Handler>(handler), q);
    }

    template <typename Handler>
    void async_execute(implementation_type& impl, const std::string& query, Handler&& handler)
    {
        detail::async_op<detail::execute_cont>(impl, std::forward<Handler>(handler), query);
    }

    template <typename Handler>
    void async_execute(implementation_type& impl, const query& q, Handler&& handler)
    {
        detail::async_op<detail::execute_cont>(impl, std::forward<Handler>(handler), q);
    }

    void cancel(implementation_type& impl)
    {
        detail::cancel(impl);
    }

    void close(implementation_type& impl)
    {
        detail::close(impl);
    }
};

} // namespace apq

#endif
