#pragma once

#include <libpq-fe.h>
#include <memory>
#include <string>
#include <map>

namespace apq::detail {

using connection_info = std::map<std::string, std::string>;

inline connection_info parse_connection_info(const std::string& conninfo_str)
{
    char* err = nullptr;
    auto conninfo = std::unique_ptr<PQconninfoOption, void (*)(PQconninfoOption*)>(
        PQconninfoParse(conninfo_str.c_str(), &err), PQconninfoFree);
    if (!conninfo)
    {
        std::string msg = err ? err : "out-of-memory";
        if (err) PQfreemem(err);
        throw std::runtime_error("parse conninfo error: " + msg);
    }
    connection_info res;
    for (auto option = conninfo.get(); option->keyword != nullptr; ++option)
    {
        if (option->val)
        {
            res[option->keyword] = option->val;
        }
    }
    return res;
}

}