#ifndef APQ_DETAIL_HANDLER_STAT_HPP
#define APQ_DETAIL_HANDLER_STAT_HPP

#include <apq/time_traits.hpp>
#include <apq/detail/moving_average_duration.hpp>

#include <boost/asio/handler_invoke_hook.hpp>
#include <utility>

namespace apq { namespace detail {

template <typename Handler>
struct latency_tracker
{
    Handler handler_;
    moving_average_duration_ptr average_roundtrip_time_;
    time_traits::time_type start_time_;

    template <typename... Args>
    void operator()(Args&&... args)
    {
        average_roundtrip_time_->add_value(time_traits::now() - start_time_);
        handler_(std::forward<Args>(args)...);
    }

    template <typename Func>
    friend void asio_handler_invoke(Func&& f, latency_tracker* ctx)
    {
        using boost::asio::asio_handler_invoke;
        asio_handler_invoke(std::forward<Func>(f), &ctx->handler_);
    }
};

template <typename Handler>
inline latency_tracker<Handler> track_latency(Handler h, moving_average_duration_ptr ptr)
{
    return { std::move(h), std::move(ptr), time_traits::now() };
}

} // namespace detail
} // namespace apq

#endif
