#ifndef APQ_DETAIL_HTON_HPP
#define APQ_DETAIL_HTON_HPP

#include <arpa/inet.h>

namespace apq { namespace detail {

#ifndef htonll
inline uint64_t htonll(uint64_t v)
{
    int num = 1;
    if (*static_cast<char*>(static_cast<void*>(&num)) == 1)
    {
        uint32_t h = htonl(uint32_t(v >> 32));
        uint32_t l = htonl(uint32_t(v & 0xFFFFFFFFLL));
        return (uint64_t(l) << 32) | h;
    }
    return v;
}
#endif

#ifndef ntohll
inline uint64_t ntohll(uint64_t v)
{
    return htonll(v);
}
#endif

} // namespace detail
} // namespace apq

#endif
