#pragma once

#include <libpq-fe.h>
#include <boost/asio/ssl/detail/openssl_init.hpp>

namespace apq { namespace detail {

template <bool Do = true>
class pq_init
{
public:
    pq_init() : initializer_(get_initializer())
    {
        // Ensure the instance is present.
        (void)instance_;
    }

private:
    pq_init(const pq_init&);
    pq_init& operator=(const pq_init&);

    static pq_init instance_;

    struct initializer
    {
        initializer()
        {
            [[maybe_unused]] boost::asio::ssl::detail::openssl_init<> init;
            ::PQinitOpenSSL(0, 0);
        }
    };

    static const initializer& get_initializer()
    {
        static initializer instance;
        return instance;
    }

    const initializer& initializer_;
};

template <bool Do>
pq_init<Do> pq_init<Do>::instance_;

} // namespace detail
} // namespace apq
