#ifndef APQ_DETAIL_SERVICE_BASE_HPP
#define APQ_DETAIL_SERVICE_BASE_HPP

#include <boost/asio/io_service.hpp>

namespace apq { namespace detail {

// Special derived service id type to keep classes header-file only.
template <typename T>
class service_id : public boost::asio::io_service::id
{
};

// Special service base class to keep classes header-file only.
template <typename T>
class service_base : public boost::asio::io_service::service
{
public:
    static service_id<T> id;

    explicit service_base(boost::asio::io_service& ios) : boost::asio::io_service::service(ios)
    {
    }
};

template <typename T>
service_id<T> service_base<T>::id;

} // namespace detail
} // namespace apq

#endif
