#ifndef APQ_INCLUDE_APQ_DETAIL_STREAMER_HPP_
#define APQ_INCLUDE_APQ_DETAIL_STREAMER_HPP_

#include <string>
#include <vector>
#include <iostream>
#include <iomanip>
#include <boost/asio.hpp>
#include <boost/type_traits/remove_const.hpp>

namespace apq { namespace detail {

template <typename T>
struct streamer
{
    static std::ostream& stream(std::ostream& s, const T& v)
    {
        return s << v;
    }
};

template <>
struct streamer<std::string>
{
    static std::ostream& stream(std::ostream& s, const std::string& v)
    {
        return s << '"' << v << '"';
    }
};

template <>
struct streamer<void*>
{
    static std::ostream& stream(std::ostream& s, const void* ptr, int sz)
    {
        const char* buf = reinterpret_cast<const char*>(ptr);
        const int w = static_cast<int>(s.width());
        const char fill = s.fill();
        s << std::hex << std::setw(2) << std::setfill('0');
        for (int i(0); i != sz; ++i)
        {
            s << "0x" << int(buf[i]) << ' ';
        }
        return s << std::dec << std::setw(w) << std::setfill(fill);
    }
};

template <typename T>
struct streamer<std::vector<T>>
{
    static std::ostream& stream(std::ostream& s, const std::vector<T>& v)
    {
        s << '{';
        typedef streamer<T> item_streamer;
        typedef typename std::vector<T>::const_iterator iter;
        if (!v.empty())
        {
            iter i = v.begin();
            item_streamer::stream(s, *i);
            for (++i; i != v.end(); ++i)
            {
                s << ',';
                item_streamer::stream(s, *i);
            }
        }
        return s << '}';
    }
};

} // namespace detail
} // namespace apq

#endif
