#ifndef APQ_RESULT_HPP
#define APQ_RESULT_HPP

#include <cstdlib>
#include <apq/error.hpp>

namespace apq {

class result
{
public:
    result() = default;

    result(const boost::system::error_code& ec) : code_(ec)
    {
    }

    result(const boost::system::error_code& ec, const char* msg) : code_(ec), msg_(msg)
    {
    }

    result(const boost::system::error_code& ec, const std::string& msg) : code_(ec), msg_(msg)
    {
    }

    result(const char* sqlstate, const std::string& msg)
        : code_(sqlstate ? error::unknown : error::no_sql_state_found)
        , msg_(msg)
        , sqlstate_(sqlstate ? sqlstate : "")
    {
    }

    const boost::system::error_code& code() const
    {
        return code_;
    }

    std::string message() const
    {
        return msg_.empty() ? code_.message() : msg_;
    }

    const std::string& sqlstate() const
    {
        return sqlstate_;
    }

    error::sqlstate::sqlstate_errors sqlstate_code() const
    {
        return static_cast<error::sqlstate::sqlstate_errors>(
            std::strtol(sqlstate_.c_str(), NULL, 36));
    }

    operator bool() const
    {
        return static_cast<bool>(code_);
    }

private:
    boost::system::error_code code_;
    std::string msg_;
    std::string sqlstate_;
};

} // namespace apq

#endif
