#pragma once

#include <mail/barbet/service/include/params.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/ymod_queuedb/include/queue.h>
#include <mail/ymod_maildb/include/module.h>
#include <ymod_webserver/response.h>


namespace barbet {

namespace archive {
DiscardParams parseDiscardParams(ymod_webserver::response_ptr s,
                                        const ymod_maildb::Module& maildb,
                                        const http_getter::ClientModule& getter,
                                        const http_getter::Endpoint& houndEndpoint);

RestoreParams parseRestoreParams(ymod_webserver::response_ptr s,
                                        const ymod_maildb::Module& maildb,
                                        const http_getter::ClientModule& getter,
                                        const http_getter::Endpoint& houndEndpoint,
                                        ymod_queuedb::Timeout timeout,
                                        const ymod_queuedb::Queue& queuedb);

}



StatusParams parseStatusParams(ymod_webserver::response_ptr s, const ymod_maildb::Module& maildb);
SettingsParams parseSettingsParams(ymod_webserver::response_ptr s, const ymod_maildb::Module& maildb);
UpdateSettingsParams parseUpdateSettingsParams(ymod_webserver::response_ptr s, const ymod_maildb::Module& maildb);

CreateBackupParams parseCreateBackupParams(ymod_webserver::response_ptr s,
                                           unsigned maxMessages,
                                           ymod_queuedb::Timeout timeout,
                                           unsigned secondsBetweenBackups,
                                           bool guardedBySetting,
                                           const ymod_queuedb::Queue& queuedb,
                                           const ymod_maildb::Module& maildb);

DeactivateBackupParams parseDeactivateBackupParams(ymod_webserver::response_ptr s,
                                                   const ymod_maildb::Module& maildb);


RestoreParams parseRestoreParams(ymod_webserver::response_ptr s,
                                 ymod_queuedb::Timeout timeout,
                                 bool guardedBySetting,
                                 const ymod_queuedb::Queue& queuedb,
                                 const ymod_maildb::Module& maildb);

}
