#pragma once

#include <mail/barbet/service/include/result.h>
#include <macs/backup_reflection.h>
#include <yamail/data/reflection.h>

BOOST_FUSION_ADAPT_STRUCT(macs::Backup,
    backup_id,
    created,
    updated,
    message_count,
    state,
    notice,
    version
)

BOOST_FUSION_ADAPT_STRUCT(macs::Restore,
    backup_id,
    created,
    updated,
    to_restore_count,
    restored_count,
    state,
    method,
    notice
)

BOOST_FUSION_ADAPT_STRUCT(barbet::StatusResult,
    primary,
    additional,
    restore
)

BOOST_FUSION_ADAPT_STRUCT(barbet::SettingsResult,
    fids,
    tabs
)

BOOST_FUSION_ADAPT_STRUCT(barbet::CreateBackupResult,
    backup_id
)

YREFLECTION_ADAPT_ENUM(macs::UserState,
    active,
    inactive,
    notified,
    frozen,
    archived,
    deleted,
    special
)
