#pragma once

#include <ymod_webserver/response.h>

#include <yamail/expected.h>

#include <mail/barbet/service/include/result.h>
#include <mail/barbet/service/include/log.h>
#include <mail/webmail/http_api_helpers/include/response.h>


namespace barbet {

class Response: public http_api::Response {
protected:
    void logErrorResponse(const std::string& body) const override;
    void logSuccessResponse(const std::string& body) const override;
    bool errorCodeToResponseCode(const mail_errors::error_code& ec, ymod_webserver::codes::code& code) const override;

    ModuleLogger log;

public:

    Response(ymod_webserver::response_ptr s)
        : http_api::Response(std::move(s))
        , log(getModuleLogger())
    { }

    using http_api::Response::with;
    void with(StatusResult&& resp) const;
    void with(SettingsResult&& resp) const;
    void with(CreateBackupResult&& resp) const;

};

}
