#include <mail/barbet/http_api/include/response.h>
#include <mail/barbet/service/include/error.h>

namespace barbet {

void Response::logErrorResponse(const std::string& body) const {
    LOGDOG_(log, error, log::where_name=stream->request()->url.make_full_path(),
            log::message=body);
}

void Response::logSuccessResponse(const std::string& body) const {
    LOGDOG_(log, notice, log::where_name=stream->request()->url.make_full_path(),
            log::message=body);
}

bool Response::errorCodeToResponseCode(const mail_errors::error_code& ec, ymod_webserver::codes::code& code) const {
    if (ec.category() == macs::getCreateBackupCategory()) {
        switch(macs::CreateBackupStatus(ec.value())) {
            case macs::CreateBackupStatus::empty_folder_list:
            case macs::CreateBackupStatus::nothing_to_backup:
            case macs::CreateBackupStatus::too_many_messages:
            case macs::CreateBackupStatus::running_restore:
            case macs::CreateBackupStatus::unique_violation:
                code = ymod_webserver::codes::bad_request; break;
            case macs::CreateBackupStatus::backup_id_not_reserved:
                code = ymod_webserver::codes::internal_server_error; break;
        }

        return true;
    } else if (ec.category() == macs::getRestoreBackupCategory()) {
        switch(macs::RestoreBackupStatus(ec.value())) {
            case macs::RestoreBackupStatus::wrong_state:
            case macs::RestoreBackupStatus::backup_is_missing:
            case macs::RestoreBackupStatus::another_backup_is_running:
            case macs::RestoreBackupStatus::unique_violation:
                code = ymod_webserver::codes::bad_request; break;
        }

        return true;
    } else if (ec.category() == macs::getDeactivateBackupCategory()) {
        switch(macs::DeactivateBackupStatus(ec.value())) {
            case macs::DeactivateBackupStatus::missing_complete_backup:
            case macs::DeactivateBackupStatus::restore_in_progress:
                code = ymod_webserver::codes::bad_request; break;
        }

        return true;
    } else if (ec.category() == getServiceCategory()) {
        switch(ServiceError(ec.value())) {
            case ServiceError::missingSetting:
            case ServiceError::backupInWrongState:
            case ServiceError::folderIssues:
            case ServiceError::frequentBackup:
            case ServiceError::notificationError:
            case ServiceError::unknownRestoreType:
            case ServiceError::nonRetriableError:
                code = ymod_webserver::codes::bad_request; break;
            case ServiceError::retriableError:
            case ServiceError::unexpectedException:
            case ServiceError::unexpectedCondition:
                code = ymod_webserver::codes::internal_server_error; break;
        }

        return true;
    } else {
        return false;
    }
}

void Response::with(StatusResult&& resp) const {
    defaultJsonResponse(resp);
}

void Response::with(SettingsResult&& resp) const {
    defaultJsonResponse(resp);
}

void Response::with(CreateBackupResult&& resp) const {
    defaultJsonResponse(resp);
}

}

#include <mail/barbet/http_api/include/reflection.h>
