#!/bin/bash

export app=barbet
export dog_name=barbet

source /opt/service_sh/environment_type.sh
source /opt/service_sh/ephemerial.sh
source /opt/service_sh/push_client_to_ephemerial.sh push-client-barbet-log
source /opt/service_sh/postgres.sh
source /opt/service_sh/tvm.sh
source /opt/service_sh/tzdata.sh
source /opt/service_sh/ssl.sh
source /opt/service_sh/link_common_files.sh
source /opt/service_sh/link_push_client.sh
source /opt/service_sh/link_nginx_config.sh

if [[ "${QA_ENVIRONMENT}" == "true" ]]; then
    rm /etc/barbet/barbet.yml

    QLOUD_FULL_ENV=$(echo ${QLOUD_DISCOVERY_COMPONENT} | grep -o -P '(?<=barbet.).+')
    QUEUE_DB_HOST="queuedb-1.queuedb.${QLOUD_FULL_ENV}"

    sed -i -e "1 s#^#${QUEUE_DB_HOST}:6432:queuedb:barbet:gavgav\n#;" /home/wmi/.pgpass

    sed -e "s#_QUEUE_DB_HOST_#${QUEUE_DB_HOST}#g" \
        /etc/barbet/barbet-qa-patch.yml > /etc/barbet/barbet.yml

    ln -sf /etc/barbet/barbet.yml-${ENVIRONMENT} /etc/barbet/barbet-base.yml
else
    ln -sf /etc/barbet/barbet.yml-${ENVIRONMENT} /etc/barbet/barbet.yml
fi

ln -sf /etc/nginx/sites-available/service.conf-${ENVIRONMENT} /etc/nginx/sites-enabled/service.conf
ln -sf /etc/nginx/sites-available/service.include /etc/nginx/sites-enabled/service.include
ln -sf /etc/nginx/sites-available/log_by_lua.include /etc/nginx/sites-enabled/log_by_lua.include
