#include <mail/barbet/service/include/blackbox.h>
#include <yamail/data/deserialization/json_reader.h>
#include <butil/network/idn.h>


namespace barbet {

namespace blackbox {

struct Address {
    std::string address;
    bool default_ = false;
};

struct User {
    std::vector<Address> addressList;
};

struct Response {
    std::vector<User> users;
};

}

yamail::expected<std::string> defaultAddress(const macs::Uid& uid,
                                             const http_getter::Client& client,
                                             const http_getter::Endpoint& bb,
                                             boost::asio::yield_context yield) {
    using namespace http_getter::detail::operators;

    const auto yy = io_result::make_yield_context(yield);

    yamail::expected<std::string> result = make_unexpected(ServiceError::unexpectedCondition, "empty bb response");
    const auto h = [&](yhttp::response resp) {
        blackbox::Response response;

        try {
            response = yamail::data::deserialization::fromJson<blackbox::Response>(resp.body);
        } catch (const boost::coroutines::detail::forced_unwind&) {
            throw;
        } catch (const boost::system::system_error& e) {
            result = yamail::make_unexpected(mail_errors::error_code(e.code()));
            return;
        } catch (const std::exception& e) {
            result = make_unexpected(ServiceError::unexpectedException, e.what());
            return;
        }

        if (response.users.size() != 1) {
            result = make_unexpected(ServiceError::unexpectedCondition, "strange number of users");
            return;
        }

        for (const blackbox::Address& address: response.users[0].addressList) {
            if (address.default_) {
                result = yamail::make_expected(idna::decode_addrspec(address.address));
                return;
            }
        }
        result = make_unexpected(ServiceError::unexpectedCondition, "no default address");
    };

    auto req = client.toGET(bb).getArgs(
        "uid"_arg=uid, "userip"_arg="127.0.0.1", "method"_arg="userinfo",
        "emails"_arg="getdefault", "format"_arg="json"
    );

    client.req(std::move(req))->call("blackbox", http_getter::withDefaultHttpWrap(h), yy);

    return result;
}

}

#define AS_IS(TYPE, NAME)                       (NAME, TYPE, TYPE, obj.NAME, obj.NAME = val)
#define CHANGE_NAME(TYPE, CONF_NAME, NAME)      (CONF_NAME, TYPE, TYPE, obj.NAME, obj.NAME = val)

YREFLECTION_ADAPT_ADT(barbet::blackbox::Address,
    AS_IS(std::string, address)
    CHANGE_NAME(bool, default, default_)
)

YREFLECTION_ADAPT_ADT(barbet::blackbox::User,
    CHANGE_NAME(std::vector<barbet::blackbox::Address>, address-list, addressList)
)

BOOST_FUSION_ADAPT_STRUCT(barbet::blackbox::Response,
    users
)

#undef CHANGE_NAME
#undef AS_IS
